<?php

namespace App\Http\Controllers\Admin\Location;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreCityRequest;
use App\Http\Requests\UpdateCityRequest;
use App\Models\City;
use App\Models\State;

class CityController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(State $state)
    {
        $cities = $state->cities()->orderBy('name')->get();

        return view('admin.location.city.index', compact('cities', 'state'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(State $state)
    {
        $city = new City;
        $states = State::whereCountryId($state->country_id)->orderBy('name')->select('id', 'name')->get();

        return view('admin.location.city.create', compact('city', 'states', 'state'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreCityRequest $request, State $state)
    {
        $data = $request->validated();
        $data['status'] = $request->has('status');

        try {
            City::create($data);

            return redirect()->route('admin.location.city.index', $state->id)->with('success', 'City created successfully.');
        } catch (\Exception $e) {
            // return $e->getMessage();
            return redirect()->back()->with('error', 'City could not be created.');
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(State $state, City $city)
    {
        $states = State::whereCountryId($state->country_id)->orderBy('name')->select('id', 'name')->get();

        return view('admin.location.city.create', compact('city', 'states', 'state'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateCityRequest $request, State $state, City $city)
    {
        $data = $request->validated();

        $data['status'] = $request->has('status');
        if ($request->has('flag')) {
            $data['flag'] = $request->file('flag')->store('cities', 'public');
        }

        try {
            $city->update($data);

            return redirect()->route('admin.location.city.index', $state->id)->with('success', 'City updated successfully.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'City could not be updated.');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(State $state, City $city)
    {
        try {
            $city->delete();

            return response()->json(['message' => 'City deleted successfully.', 'status' => 'success']);
        } catch (\Exception $e) {
            return response()->json(['message' => 'City could not be deleted.', 'status' => 'error'], 500);
        }
    }
}
